// Copyright 1994, 1995 by Jon Dart.  All Rights Reserved.
// secondar.cpp : implementation file
//

#include "stdafx.h"
#include "secondar.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// SecondarySearchOptions property page

IMPLEMENT_DYNCREATE(SecondarySearchOptions, CPropertyPage)

SecondarySearchOptions::SecondarySearchOptions() : CPropertyPage(SecondarySearchOptions::IDD)
{
	//{{AFX_DATA_INIT(SecondarySearchOptions)
	m_2ndaryType = -1;
	m_PlyData = _T("");
	m_TimeData = _T("");
	//}}AFX_DATA_INIT
}

SecondarySearchOptions::~SecondarySearchOptions()
{
}

void SecondarySearchOptions::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(SecondarySearchOptions)
	DDX_Control(pDX, IDD_PLY_TEXT2, m_PlyText);
	DDX_Control(pDX, IDD_PLY_EDIT2, m_PlyEdit);
	DDX_Control(pDX, IDD_TIME_EDIT2, m_TimeEdit);
	DDX_Control(pDX, IDD_TIME_TEXT2, m_TimeText);
	DDX_Radio(pDX, ID_2NDARY_NONE, m_2ndaryType);
	DDX_Text(pDX, IDD_PLY_EDIT2, m_PlyData);
	DDX_Text(pDX, IDD_TIME_EDIT2, m_TimeData);
	//}}AFX_DATA_MAP
}


BOOL SecondarySearchOptions::OnInitDialog()
{
        CPropertyPage::OnInitDialog();
        new_type(m_2ndaryType);
        return FALSE;
}

BEGIN_MESSAGE_MAP(SecondarySearchOptions, CPropertyPage)
	//{{AFX_MSG_MAP(SecondarySearchOptions)
        ON_BN_CLICKED(ID_2NDARY_NONE, On2ndaryNone)
        ON_BN_CLICKED(ID_2NDARY_TOURN, On2ndaryTourn)
        ON_BN_CLICKED(ID_2NDARY_FIXED, On2ndaryFixed)
        ON_BN_CLICKED(IDOK, OnOK)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// SecondarySearchOptions message handlers

void SecondarySearchOptions::On2ndaryNone()
{
    new_type(0);
}

void SecondarySearchOptions::On2ndaryTourn()
{
    new_type(2);        
}

void SecondarySearchOptions::On2ndaryFixed()
{
    new_type(1);
}

void SecondarySearchOptions::new_type(int srctype)
{
   ASSERT(srctype < 4);
   switch (srctype)
   {
     case 0: /* None */
       m_PlyText.ShowWindow(SW_HIDE);
       m_TimeText.ShowWindow(SW_HIDE);
       m_PlyEdit.ShowWindow(SW_HIDE);
       m_TimeEdit.ShowWindow(SW_HIDE);
       break;
    case 1: /* Game */
       m_PlyText.ShowWindow(SW_SHOW);
       m_PlyEdit.ShowWindow(SW_SHOW);
       m_TimeText.ShowWindow(SW_HIDE);
       m_TimeEdit.ShowWindow(SW_HIDE);
       m_PlyText.SetWindowText("Minutes/Game");
       break;
    case 2: /* Tournament */
       m_PlyText.ShowWindow(SW_SHOW);
       m_PlyEdit.ShowWindow(SW_SHOW);
       m_TimeText.ShowWindow(SW_SHOW);
       m_TimeEdit.ShowWindow(SW_SHOW);
       m_PlyText.SetWindowText("Moves:");
       break;
    }
}
